function [S] = integrate(time,input)
% new_X = remove_rep(Dif,X)
%
% Input Variables
%   input - the input signal
%   time - the time of the integration
% Output Variables
%   S- the integrated signal
%
% Description
%   integrates according to the Simposon's rule
% Created
%   8/23/2006, Mohamed A Mneimneh, Marquette University
%
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).
% Modified

S = 0;

for i = 1:length(input)-2
    a = time(i);
    b = time(i+2);
    S = S + (abs(b-a)/6)*( input(i) + 4*input(i+1) + input(i+2) );
end